/*
	File:		MegaDialog.cp

	Contains:	Code to drive our MegaDialog example.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#include "MegaDialog.h"
#include "Appearance.h"
#include "ProgressPane.h"
#include "SliderPane.h"
#include "ClassicPane.h"
#include "TextPane.h"
#include "LayoutPane.h"
#include "NewButtonPane.h"

enum
{
	kNoPane			= 0,
	kClassicPane	= 1,
	kSliderPane		= 2,
	kTextPane	 	= 3,
	kProgressPane	= 4,
	kLayoutPane		= 5,
	kNewPane		= 6
};

MegaDialog::MegaDialog() : BaseDialog( 6000 )
{
	fPane = nil;
	SwitchPane( kClassicPane );
}

MegaDialog::~MegaDialog()
{
	delete fPane;
}

void
MegaDialog::Idle()
{
	if ( fPane ) fPane->Idle();
}

void
MegaDialog::SwitchPane( SInt16 paneIndex )
{
	ControlHandle		control;

	if ( paneIndex == 0 ) return;

	delete fPane;
	fPane = nil;	
		
	GetDialogItemAsControl( fWindow, 1, &control );
	SetControlValue( control, paneIndex );

	switch ( paneIndex )
	{
		case kProgressPane:
			fPane = new ProgressPane( fWindow, CountDITL( fWindow ) );
			break;

		case kSliderPane:
			fPane = new SliderPane( fWindow, CountDITL( fWindow ) );
			break;

		case kClassicPane:
			fPane = new ClassicPane( fWindow, CountDITL( fWindow ) );
			break;

		case kTextPane:
			fPane = new TextPane( fWindow, CountDITL( fWindow ) );
			break;
		
		case kLayoutPane:
			fPane = new LayoutPane( fWindow, CountDITL( fWindow ) );
			break;
		
		case kNewPane:
			fPane = new NewButtonPane( fWindow, CountDITL( fWindow ) );
			break;
	}	
}

void
MegaDialog::HandleItemHit( SInt16 item )
{
	if ( item == 1 )
	{
		ControlHandle		control;
		
		GetDialogItemAsControl( fWindow, 1, &control );
		SwitchPane( GetControlValue( control ) );
	}
	else if ( fPane )
	{
		fPane->ItemHit( item );
	}
}